/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	AngularDimension.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CDrawing.h"
#include "CApplication.h"


HRESULT AngularDimension(IDesign *pDesign, IDrawingDocument *pDrawingDoc, IGraphic *pGraph1, IGraphic *pGraph2, IAngularDimLine **angulardim) 
{
	START_METHOD("AngularDimension")
	//	Creates an Angular Dimension

	HRESULT status = CONV_SUCCESS ;

	CHECK_VAR_STATUS(pDrawingDoc)

	IDrawingDocument *activeDoc = CAST(IDrawingDocument, pDrawingDoc);
	
	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, activeDoc);

	IDrawingDocOthers *doc1 = CAST(IDrawingDocOthers, pDrawingDoc);

	// get the drawing
	IDrawing *localDraw= NULL;
	status = activeDoc->GetDrawing(&localDraw);
	CHECK_RETURN_STATUS(status)

	IDesignDetail *pDetail = NULL;
	status = localDraw->GetDetail(pDesign, FALSE,&pDetail);
	CHECK_RETURN_STATUS(status)
	
	// get paper geometry
	IGeometry *pGeom1 = NULL;
	status = activeDoc->GetPaperGeometry(pGraph1,&pGeom1);
	CHECK_RETURN_STATUS(status)
	
	IGeometry *pGeom2 = NULL;
	status = activeDoc->GetPaperGeometry(pGraph2,&pGeom2);
	CHECK_RETURN_STATUS(status)


	// get design instance
	IDesignInstance *pView1 = NULL;
	status = pGeom1->GetInstance(&pView1);
	CHECK_RETURN_STATUS(status)
	
	IDesignInstance *pView2 = NULL;
	status = pGeom2->GetInstance(&pView2);
	CHECK_RETURN_STATUS(status)

//	IDrawingDocStatic *localStaticDoc = CAST(IDrawingDocStatic, pDrawingDoc);

	IDispatch *pDefinition = NULL;
//	status = localStaticDoc->CreateAngularDefn(pGeom1, pGeom2, &pDefinition);
	CHECK_RETURN_STATUS(status)
	
	IDimension *pDimension = NULL;
	status = (GetCLASS(Dimension))->CreateDimension(pDetail, 4, CAST(IGeometry, pDefinition), &pDimension);
	CHECK_RETURN_STATUS(status)
	
	IVector *pPosition = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.2, 0.1, 0, &pPosition);
	CHECK_RETURN_STATUS(status)

	IAngularDimLine *pAngularDim = NULL;
	status = (GetCLASS(AngularDimLine))->CreateAngularDimLine(pPosition, pDimension, CAST(IHiddenLine, pView1), CAST(IHiddenLine, pView2), &pAngularDim);
	CHECK_RETURN_STATUS(status)
	
	IDimTol *pTolerance = NULL;
	status = (GetCLASS(DimTol))->CreateDimTol(pDetail, pDimension, &pTolerance);
	CHECK_RETURN_STATUS(status)
	
	IDimensionCallout *pCallout = NULL;
	status = (GetCLASS(DimensionCallout))->CreateDimensionCallout(pTolerance,&pCallout);
	CHECK_RETURN_STATUS(status)
	
	IDimLineText *pText = NULL;
	status = (GetCLASS(DimLineText))->CreateDimLineText(CAST(IDimLine,pAngularDim), CAST(ICallout, pCallout), pPosition, 0.0035,&pText);
	CHECK_RETURN_STATUS(status)
	
	ICalloutGroup *localCalloutGroup = CAST(ICalloutGroup, pText);
	
	status = localCalloutGroup->SetControlPoint(1, pPosition);
	CHECK_RETURN_STATUS(status)

	// Get the active sheet in current drawing
	ISheet *pSheet = NULL;
	status = pDrawingDoc->GetActiveSheet(&pSheet);
	CHECK_RETURN_STATUS(status)

	status = pSheet->AddDimLine(CAST(IDimLine, pAngularDim));
	CHECK_RETURN_STATUS(status)

	// Add center line
	// To be done

	*angulardim = pAngularDim;

	END_METHOD("AngularDimension")
}
